// Online Game Player Database Class (c)2004 Niall FitzGibbon
// You may redistribute this file (playerdb.cpp) or modifications of this file as long as this two-line comment remains intact.
// You may distribute object code resulting from compiling this source code so long as such a credit appears in the documentation for the distribution.

#include "stdafx.h"

#include "playerdb.h"

CPlayerDatabase g_PlayerDatabase;

bool operator<(const playerdbname_t &o1, const playerdbname_t &o2)
{
	return o1.iCount < o2.iCount;
}

CPlayerDatabase::CPlayerDatabase(void)
{
	strcpy(m_szAutoSaveFile, "#noautosave");
	m_mPlayers.clear();
}

CPlayerDatabase::~CPlayerDatabase(void)
{
	if(strncmp(m_szAutoSaveFile, "#noautosave", MAX_PATH))
		SaveToFile(m_szAutoSaveFile);
}

void CPlayerDatabase::LoadFromFile(char *szFile)
{
	DWORD dwFileVersion = 0;
	PDB_CURRENT_HEADER_VERSION header;
	ifstream f(szFile, ios::binary);

	if(!f)
		return;

	m_mPlayers.clear();

	ZeroMemory(&header, sizeof(header));
	f.read((char*)&header, sizeof(playerdbfileheader_basic_t));
	f.seekg(0, ios::beg);

	if(header.dwPlayerDatabaseSignature != PLAYERDATABASE_SIGNATURE)
		return;

	dwFileVersion = header.dwVersion;

	switch(dwFileVersion)
	{
	case PDB_CURRENT_VERSION:
		LoadFromFile_version1(f);
		break;
	default:
		break;
	}
}

void CPlayerDatabase::LoadFromFile_version1(ifstream &f)
{
	playerdbfileheader_version1_t fileheader;
	playerdbfileentry_version1_t fileentry;

	ZeroMemory(&fileheader, sizeof(fileheader));
	f.read((char*)&fileheader, sizeof(fileheader));

	for(int i = 0; i < fileheader.iNumberOfEntries; i++)
	{
		playerdbentry_t entry;
		ZeroMemory(&fileentry, sizeof(fileentry));
		f.read((char*)&fileentry, sizeof(fileentry));
		
		entry.dwPlayerUniqueID = fileentry.dwPlayerUniqueID;
		ZeroMemory(&entry.misc, sizeof(entry.misc));
		memcpy(&entry.misc, &fileentry.misc, sizeof(fileentry.misc));
		for(int j = 0; j < fileentry.iNumberOfNames; j++)
		{
			playerdbname_t dbname;
			f.read((char*)&dbname.iCount, sizeof(dbname.iCount));
			char c;
			do
			{
				f.get(c);
				if(c)
					dbname.sName += c;
			} while(c);
			entry.lNames.push_back(dbname);
		}
		m_mPlayers.insert(make_pair(entry.dwPlayerUniqueID, entry));
	}
}

void CPlayerDatabase::SaveToFile(char *szFile)
{
	PDB_CURRENT_HEADER_VERSION header;
	PDB_CURRENT_ENTRY_VERSION entry;
	ofstream f(szFile, ios::binary | ios::trunc);

	if(!f)
		return;

	header.dwPlayerDatabaseSignature = PLAYERDATABASE_SIGNATURE;
	header.dwVersion = PDB_CURRENT_VERSION;
	header.iNumberOfEntries = m_mPlayers.size();

	f.write((char*)&header, sizeof(header));

	for(map<DWORD, playerdbentry_t>::iterator i = m_mPlayers.begin(); i != m_mPlayers.end(); i++)
	{
		entry.dwPlayerUniqueID = i->second.dwPlayerUniqueID;
		memcpy(&entry.misc, &i->second.misc, sizeof(entry.misc));
		entry.iNumberOfNames = i->second.lNames.size();
		f.write((char*)&entry, sizeof(entry));
		for(list<playerdbname_t>::iterator j = i->second.lNames.begin(); j != i->second.lNames.end(); j++)
		{
			f.write((char*)&j->iCount, sizeof(j->iCount));
			f.write(j->sName.c_str(), j->sName.size() + 1);
		}
	}
}

void CPlayerDatabase::AddPlayerName(DWORD dwUniqueID, char *szName)
{
	playerdbentry_t entry;
	entry.dwPlayerUniqueID = dwUniqueID;
	// zero the misc info, it can be set later via other functions
	ZeroMemory(&entry.misc, sizeof(entry.misc));

	if(entry.dwPlayerUniqueID == 0)
		return;

	// see if that unique id is already in the database, if so move on to adding the name
	map<DWORD, playerdbentry_t>::iterator i = m_mPlayers.find(dwUniqueID);
	if(i != m_mPlayers.end())
	{
		// existing entry, so check to see if this name is already register too
		bool bExistingName = false;
		for(list<playerdbname_t>::iterator j = i->second.lNames.begin(); j != i->second.lNames.end(); j++)
		{
			if(j->sName == szName)
			{
				// just increase the usage count and resort the list
				j->iCount++;
				bExistingName = true;
				i->second.lNames.sort();
				break;
			}
		}
		if(!bExistingName)
		{
			playerdbname_t newname;
			newname.iCount = 1;
			newname.sName = szName;
			// don't need to sort since 1 is the minimum count anyway
			// push to the front because list is sorted in increasing order
			i->second.lNames.push_front(newname);
		}
	}
	else
	{
		// new entry, so this is the first name
		playerdbname_t newname;
		newname.iCount = 1;
		newname.sName = szName;
		// don't need to sort the list since there is only one entry
		entry.lNames.push_back(newname);
		m_mPlayers.insert(make_pair(entry.dwPlayerUniqueID, entry));
	}
}

int CPlayerDatabase::GetPlayerNames(DWORD dwUniqueID, vector<string> *pvNames, int iNumberOfNames)
{
	pvNames->clear();

	map<DWORD, playerdbentry_t>::iterator i = m_mPlayers.find(dwUniqueID);
	if(i == m_mPlayers.end())
		return 0;

	int c = 0;
	list<playerdbname_t>::iterator j = i->second.lNames.end();
	while(j != i->second.lNames.begin())
	{
		j--;
		pvNames->push_back(j->sName);
		c++;
		if(c == iNumberOfNames)
			break;
	}

	return c;
}

int CPlayerDatabase::GetNumberOfUniquePlayers(void)
{
	return m_mPlayers.size();
}

void CPlayerDatabase::SetAutoSaveFile(char *szFile)
{
	strncpy(m_szAutoSaveFile, szFile, MAX_PATH);
}